/*
 * Decompiled with CFR 0.152.
 */
package oracle.ntpg.nlslang;

import oracle.ntpg.nlslang.Lang2Charset;
import oracle.ntpg.nlslang.Lang2Territory;
import oracle.ntpg.nlslang.ObjFactoryUnix;
import oracle.ntpg.nlslang.ObjFactoryWind;

abstract class ObjFactory {
    static final int WINDOWS = 1;
    static final int UNIX = 2;
    static int m_osArch;
    static ObjFactory m_factory;
    static Lang2Charset m_lang2CS;
    static Lang2Territory m_lang2Terr;

    static ObjFactory getInstance() {
        if (m_factory == null) {
            String string = System.getProperty("os.name");
            m_osArch = string.startsWith("Windows") ? 1 : 2;
            switch (m_osArch) {
                case 1: {
                    m_factory = new ObjFactoryWind();
                    break;
                }
                default: {
                    m_factory = new ObjFactoryUnix();
                    break;
                }
            }
        }
        return m_factory;
    }

    abstract Lang2Charset getLang2Charset();

    abstract Lang2Territory getLang2Territory();

    ObjFactory() {
    }
}

